Imports System.IO

Public Class Main

  Private Overloads Shared Function ValidCommandLine( _
    ByVal CommandLine As String) As Boolean
    Return Sorter.Valid(CommandLine)
  End Function

  Private Shared Function GetEnumerator( _
    ByVal CommandLine As String) As IEnumerator
    Return Command.Split(", ".ToCharArray()).GetEnumerator
  End Function

  Private Overloads Shared Sub ProcessEach( _
   ByVal CommandLine As String)
    ProcessEach(GetEnumerator(CommandLine))
  End Sub

  Private Overloads Shared Sub ProcessEach( _
    ByVal Enumerator As IEnumerator)
    While (Enumerator.MoveNext())
      If (ValidCommandLine(Enumerator.Current)) Then
        Sorter.Sort(Enumerator.Current)
      End If
    End While
  End Sub

  Public Shared Sub Process(ByVal CommandLine As String)
    If (Help.WantsHelp(CommandLine)) Then
      Help.Show()
    Else
      ProcessEach(CommandLine)
    End If
  End Sub

  Public Shared Sub Main()
    Process(Command())
  End Sub
End Class

Public Class Sorter
  Private FFileName As String
  Private FData As ArrayList

  Public Property FileName() As String
    Get
      Return FFileName
    End Get
    Set(ByVal Value As String)
      FFileName = Value
    End Set
  End Property

#Region " FileSystemWatcher Example "
  Private Watcher As FileSystemWatcher

  Private Sub OnCreated(ByVal sender As Object, _
    ByVal e As System.IO.FileSystemEventArgs)
    Console.WriteLine("Created: " & e.FullPath)
  End Sub

  Private Sub AddWatcher()
    Watcher = New FileSystemWatcher("..\", "*.tmp")
    Watcher.EnableRaisingEvents = True
    AddHandler Watcher.Created, AddressOf OnCreated
  End Sub
#End Region

  Public Sub New(ByVal AFileName As String)
    FData = New ArrayList()
    FFileName = AFileName
    AddWatcher()
  End Sub

  Public Sub Read()
    Dim Reader As TextReader = File.OpenText(FFileName)

    Try
      While Reader.Peek <> -1
        FData.Add(Reader.ReadLine)
      End While

    Finally
      Reader.Close()
    End Try

  End Sub

  Private Sub WriteElapsedTime(ByVal Elapsed As Double)
    Debug.WriteLine(String.Format("Elapsed milliseconds: {0} ", Elapsed))
  End Sub

  Public Sub TimedSort()
    Dim Start As Double = Timer
    Sort()
    WriteElapsedTime(Timer - Start)
  End Sub

  Public Sub Sort()
    FData.Sort(New StringComparer())
  End Sub

  Private Function TempFileName() As String

    Return "..\" & Path.GetFileName(Path.GetTempFileName)
  End Function

  Public Sub Write()
    Dim Writer As TextWriter = File.CreateText(TempFileName())
    Dim Enumerator As IEnumerator = FData.GetEnumerator

    Try
      While Enumerator.MoveNext
        Writer.WriteLine(Enumerator.Current)
      End While

    Finally
      Writer.Close()
    End Try

  End Sub

  Private Sub Run()
    Read()
    TimedSort()
    Write()
  End Sub

  Public Shared Sub Sort(ByVal FileName As String)
    Dim Instance As New Sorter(FileName)
    Dim Thread As New Threading.Thread(AddressOf Instance.Run)
    Thread.Start()
  End Sub

  Public Shared Function Valid(ByVal CommandLine As String) As Boolean
    Return System.IO.File.Exists(CommandLine)
  End Function

End Class

Public Class Help
  Private Shared Function ContainsHelpSwitch( _
    ByVal CommandLine As String) As Boolean

    Return CommandLine.IndexOf("-?") > -1 Or _
      CommandLine.ToUpper.IndexOf("-H") > -1 Or _
      CommandLine.ToUpper.IndexOf("-HELP") > -1 Or CommandLine = ""

  End Function

  Public Shared Function WantsHelp(ByVal CommandLine As String) As Boolean
    Return ContainsHelpSwitch(CommandLine)
  End Function

  Public Shared Function Usage() As String
    Return _
      "Usage: filesort filename.txt | [-h,-?-help] " & vbCrLf & _
      "Sorts lines of text in file" & vbCrLf & _
      "-h|-?-help - Displays the help message" & vbCrLf
  End Function

  Public Shared Sub Show()
    Console.WriteLine(Usage())
  End Sub
End Class

Public Class StringComparer
  Implements IComparer

  Public Function Compare(ByVal x As Object, _
    ByVal y As Object) As Integer _
    Implements System.Collections.IComparer.Compare
    Try
      Return String.Compare(x.ToString.Substring(0, 3), _
        y.ToString.Substring(0, 3))
    Catch
      Return String.Compare(x.ToString, y.ToString)
    End Try
  End Function
End Class